;Scripts for HjPad 
;by DB and DV
;Copyright 1999 by Henter-Joyce, Inc.

include "hjconst.jsh"
include "hjglobal.jsh"
include "HjPad.jsh"
include "HjPad.jsm"
globals
	int HJPadFirstTime

Void Function AutoStartEvent ()
if (HJPadFirstTime == 0) then
	let HJPadFirstTime = 1;
	Say (msg6+msg5+GetScriptKeyName ("HotKeyHelp"), OT_HELP); "Press insert + h for Jaws hot keys"
	Say (msg7+msg5+GetScriptKeyName ("ScreenSensitiveHelp"), OT_HELP); "Press insert + f1 for ScreenSensitiveHelp"
EndIf
EndFunction

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
If ((GetWindowClass (focusWindow) == wcDialog) || (GetWindowClass (focusWindow) == wcStatic) && (GetWindowName (focusWindow) == wn1)) then return EndIf
if (GlobalPrevApp != AppWindow && AppWindow != FocusWindow) then
  ; we've switched to a different app main window,
  ; and it does not have the focus, so announce it
  SayWindowTypeAndText (AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
  || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
  If ((RealWindow != AppWindow) && (RealWindow != FocusWindow)) then
        If (RealWindowName != wn1) then
      SayWindowTypeAndText (RealWindow)
    EndIf
  endif
EndIf
;wn1 = "Check Spelling"
If ((RealWindowName == wn1) && (GetControlId (GetFocus ()) == iD_Spelling_Edit)) then
	PerformScript ReadMisSpelledAndSuggestion()
	Return
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
  SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
  SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Void Function SayHighlightedText (handle hWnd, string buffer)
var
	int iHwndControl,
	int iFocusControl,
	string sWinName
let iHwndControl = GetControlId (hWnd)
let iFocusControl = GetControlId (GetFocus ())
let sWinName = GetWindowName (GetRealWindow (GetFocus ()))
;wn1 = "Check Spelling"
if (sWinName == wn1) then
	if(GetWindowClass (GetFocus ()) == wcListBox) then
		Say (buffer, OT_BUFFER)
		Return
	EndIf ; End of control check keep it from chattering
	If (iFocusControl == iD_Spelling_Edit) ||
	(GetWindowClass (hWnd) == wcDialog) ||
	(GetWindowClass (hWnd) == wcStatic) ||
	(iHwndControl == iD_Spelling_Edit) then
		Return
	EndIf
	Return
EndIf
;Say (buffer, OT_BUFFER)
SayHighlightedText (hWnd, buffer)
EndFunction

Void Function SayNonHighlightedText (handle hWnd, string buffer)
var
	int iHwndControl,
	int iFocusControl,
	string sWinName
let iHwndControl = GetControlId (hWnd)
let iFocusControl = GetControlId (GetFocus ())
let sWinName = GetWindowName (GetRealWindow (GetFocus ()))
;wn1 = "Check Spelling"
if (sWinName == wn1) then
	if (iHwndControl != iFocusControl) then
		Return
	EndIf ; End of control check keep it from chattering
	if (iFocusControl != iD_Spelling_Edit) then
		Return; no chatter in list or combo boxes
	EndIf
	;Now set to run ReadMisSpelledAndSuggestion ()
	PerformScript ReadMisSpelledAndSuggestion ()
EndIf
SayNonHighlightedText (hWnd, buffer)
EndFunction

Void Function SayFocusedWindow ()
var
	int iControl,
	string sWinName
let iControl = GetControlId (GetFocus ())
let sWinName = GetWindowName (GetRealWindow (GetFocus ()))
;wn1 = "Check Spelling"
if (sWinName == wn1) &&
(iControl == ID_Spelling_Edit) then
	Return
Elif GetControlID (GetFocus ()) == 1042 then
	SayFocusedWindow ()
	{Control+Home}
	PerformScript SayAll()
	Return
EndIf
SayFocusedWindow ()
EndFunction

Script ScriptFileName ()
ScriptAndAppNames ("HjPad")
EndScript

Script ReadMisSpelledAndSuggestion ()
var
	handle hWnd,
	handle hGrip,
	int iControl,
	string sWinName,
	string sClass
let hWnd = GetRealWindow (GetFocus ())
let hGrip = GetCurrentWindow ()
let iControl = GetControlId (hGrip)
let sWinName = GetWindowName (hWnd)
;wn1 = "Check Spelling"
if (sWinName == wn1) then ; we are in the Spelling dialog
	SaveCursor ()
	RouteInvisibleToPc ()
	InvisibleCursor ()
	MoveToControl (hWnd, iD_Spelling_Edit)
	If (GetVerbosity () == 0) then 
		PerformScript SayWindowPromptAndText()
	Else
		SayWord ()
	EndIf
	SpellString (GetWord ())
	MoveToWindow (FindDescendantWindow (hWnd, iD_Suggestions_List))
	If (StringLength (GetWord ()) == 0) then
		Say (msg3, OT_MESSAGE); "No Suggestions"
		RestoreCursor ()
		Return
	EndIf
	If (GetVerbosity () == 0) then
		Say (msg1, OT_MESSAGE); "Suggestions:"
	EndIf
	;to avoid incorrect speech from the subsequent combo box
;	FindFirstAttribute (Attrib_Highlight)
;	FindNextAttribute (attrib_Highlight)
	Say (GetWindowText (GetCurrentWindow (), true), OT_BUFFER)
	;SayWord ()
	SpellString (GetWindowText (GetCurrentWindow (), true))
	RestoreCursor ()
Else
	Say (msg4, OT_MESSAGE); "Not in SpellChecker"
EndIf
EndScript


Script HotKeyHelp ()
;wn2 = "List View Tracking My Progress"
If GetWindowName (GetRealWindow (GetCurrentWindow ())) == wn2 then
	Say (msg26, ot_help) ; "To mark an item as completed, press C",
	Say (msg27, ot_help) ; "To mark an item as not completed, press N"
	return
Endif
PerformScript HotKeyHelp ()
EndScript

Script ScreenSensitiveHelp ()
If GetControlID (GetCurrentWindow ()) == 1168 then
	Say (msg8, ot_help) ;"This is a list view"
	Say (msg9, ot_help); "It contains three columns"
	Say (msg10, ot_help);"Command, Category and status"
	Say (msg11, ot_help) ;"use the arrow keys to read through the items"
	Say (msg12, ot_help) ;"or press the first letter to jump to a desired item"
	Say (msg13, ot_help) ;"items can be contained in one or more columns"
	Say (msg14, ot_help) ;"to select a contiguous group of items"
	Say (msg15, ot_help) ;"hold down the shift key as you arrow up or down"
	Say (msg16, ot_help) ;"to select a non contiguous group of items"
	Say (msg17, ot_help) ;"hold down the control key as you arrow up and down"
	Say (msg18, ot_help) ;"and use control plus space bar"
	Say (msg19, ot_help) ;" to select or unselect items"
	Say (msg20, ot_help) ;"to here the items that have been selected"
	Say (msg21, ot_help) ;"use shift plus insert plus down arrow"
	Say (msg22, ot_help) ;"Use the Tab key to move to the next Control"
Elif GetControlID (GetCurrentWindow ()) == 1042 then
	Say (msg23, ot_help) ;"This text is reed only"
	Say (msg24, ot_help) ;"you can navigate and read text with the pc cursor"
	Say (msg25, ot_help) ;"but you cannot edit the text"
Else
	PerformScript ScreenSensitiveHelp ()
Endif
EndScript
